/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.encoder;

import com.revrobotics.NativeResourceCleaner;
import com.revrobotics.REVDevice;
import com.revrobotics.REVLibError;
import com.revrobotics.RelativeEncoder;
import com.revrobotics.ResetMode;
import com.revrobotics.encoder.config.DetachedEncoderAccessor;
import com.revrobotics.encoder.config.DetachedEncoderConfig;
import com.revrobotics.jni.DetachedEncoderJNI;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DetachedEncoder
extends NativeResourceCleaner
implements REVDevice,
RelativeEncoder {
    protected long handle;
    private final int deviceId;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Model model;
    public final DetachedEncoderAccessor detachedEncoderAccessor;

    public DetachedEncoder(int id, Model model) {
        this.deviceId = id;
        this.model = model;
        if (DetachedEncoderJNI.registerId(this.deviceId) == REVLibError.kDuplicateCANId.value) {
            throw new IllegalStateException("A DetachedEncoder instance has already been created with this device ID: " + this.deviceId);
        }
        this.handle = DetachedEncoderJNI.create(id, model.ordinal());
        this.registerCleaner(this.handle);
        this.detachedEncoderAccessor = new DetachedEncoderAccessor(this.handle);
    }

    public int getDeviceId() {
        this.throwIfClosed();
        return this.deviceId;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public double getPosition() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getEncoderPosition(this.handle);
    }

    public double getAngle() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getEncoderAngle(this.handle);
    }

    public double getRawAngle() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getEncoderRawAngle(this.handle);
    }

    @Override
    public double getVelocity() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getEncoderVelocity(this.handle);
    }

    @Override
    public REVLibError setPosition(double position) {
        this.throwIfClosed();
        return REVLibError.fromInt(DetachedEncoderJNI.setEncoderPosition(this.handle, position));
    }

    public Faults getFaults() {
        this.throwIfClosed();
        int faultsBitfield = DetachedEncoderJNI.getFaultsBitfield(this.handle);
        return new Faults((faultsBitfield & 1) != 0, (faultsBitfield >> 1 & 1) != 0, (faultsBitfield >> 2 & 1) != 0, (faultsBitfield >> 3 & 1) != 0);
    }

    public Faults getStickyFaults() {
        this.throwIfClosed();
        int faultsBitfield = DetachedEncoderJNI.getStickyFaultsBitfield(this.handle);
        return new Faults((faultsBitfield & 1) != 0, (faultsBitfield >> 1 & 1) != 0, (faultsBitfield >> 2 & 1) != 0, (faultsBitfield >> 3 & 1) != 0);
    }

    public void clearFaults() {
        this.throwIfClosed();
        DetachedEncoderJNI.clearFaults(this.handle);
    }

    public FirmwareVersion getFirmwareVersion() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getFirmwareVersion(this.handle);
    }

    public void configure(DetachedEncoderConfig config, ResetMode resetMode) {
        String configString = config.flatten();
        DetachedEncoderJNI.configure(this.handle, configString, resetMode == ResetMode.kResetSafeParameters);
    }

    public PeriodicStatus0 getStatus0() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getStatus0(this.handle);
    }

    public PeriodicStatus1 getStatus1() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getStatus1(this.handle);
    }

    public PeriodicStatus2 getStatus2() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getStatus2(this.handle);
    }

    public PeriodicStatus3 getStatus3() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getStatus3(this.handle);
    }

    public PeriodicStatus4 getStatus4() {
        this.throwIfClosed();
        return DetachedEncoderJNI.getStatus4(this.handle);
    }

    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        this.isClosed.set(true);
        DetachedEncoderJNI.close(this.handle);
    }

    @Override
    protected NativeResourceCleaner.OnClean getCleanAction() {
        return DetachedEncoderJNI::destroy;
    }

    private void throwIfClosed() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("This DetachedEncoder object has previously been closed.");
        }
    }

    public static enum Model {
        Unknown,
        MAXSplineEncoder;

    }

    public record Faults(boolean unexpected, boolean canTx, boolean canRx, boolean eeprom) {
    }

    public record FirmwareVersion(int major, int minor, int fix, int prerelease, int hardwareMajor, int hardwareMinor) {
    }

    public record PeriodicStatus0(int deviceModel) {
    }

    public record PeriodicStatus1(boolean unexpectedFault, boolean hasResetFault, boolean canTxFault, boolean canRxFault, boolean eepromFault, boolean stickyUnexpectedFault, boolean stickyHasResetFault, boolean stickyCanTxFault, boolean stickyCanRxFault, boolean stickyEepromFault) {
    }

    public record PeriodicStatus2(float rawAngle, float angle) {
    }

    public record PeriodicStatus3(int timestamp, float position) {
    }

    public record PeriodicStatus4(int timestamp, float velocity) {
    }
}

