/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub;

import com.revrobotics.NativeResourceCleaner;
import com.revrobotics.REVDevice;
import com.revrobotics.REVLibError;
import com.revrobotics.jni.CANServoHubJNI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

public abstract class ServoHubLowLevel
extends NativeResourceCleaner
implements REVDevice,
AutoCloseable {
    protected final long servoHubHandle;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final int deviceId;
    private String firmwareString = "";

    public ServoHubLowLevel(int deviceId) {
        this.deviceId = deviceId;
        if (CANServoHubJNI.c_ServoHub_RegisterId(deviceId) == REVLibError.kDuplicateCANId.value) {
            throw new IllegalStateException("A CANServoHub instance has already been created with this device ID: " + deviceId);
        }
        this.servoHubHandle = CANServoHubJNI.c_ServoHub_Create(deviceId);
        this.registerCleaner(this.servoHubHandle);
    }

    @Override
    public void close() {
        boolean wasClosed = this.isClosed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        CANServoHubJNI.c_ServoHub_Close(this.servoHubHandle);
    }

    @Override
    protected NativeResourceCleaner.OnClean getCleanAction() {
        return CANServoHubJNI::c_ServoHub_Destroy;
    }

    public int getDeviceId() {
        this.throwIfClosed();
        return this.deviceId;
    }

    public FirmwareVersion getFirmwareVersion() {
        this.throwIfClosed();
        FirmwareVersion version = new FirmwareVersion();
        CANServoHubJNI.c_ServoHub_GetFirmwareVersion(this.servoHubHandle, version);
        return version;
    }

    public String getFirmwareVersionString() {
        this.throwIfClosed();
        if (this.firmwareString == "") {
            FirmwareVersion version = this.getFirmwareVersion();
            StringBuilder firmwareString = new StringBuilder();
            firmwareString.append("fw v").append(version.firmwareYear).append(".").append(version.firmwareMinor).append(".").append(version.firmwareFix).append(", hw v").append(version.hardwareMajor).append(".").append(version.hardwareMinor);
            this.firmwareString = firmwareString.toString();
        }
        return this.firmwareString;
    }

    public void setPeriodicFrameTimeout(int timeout_ms) {
        this.throwIfClosed();
        CANServoHubJNI.c_ServoHub_SetPeriodicFrameTimeout(this.servoHubHandle, timeout_ms);
    }

    public REVLibError setCANTimeout(int timeout_ms) {
        this.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_SetCANTimeout(this.servoHubHandle, timeout_ms));
    }

    public void setCANMaxRetries(int numRetries) {
        this.throwIfClosed();
        CANServoHubJNI.c_ServoHub_SetCANMaxRetries(this.servoHubHandle, numRetries);
    }

    public void setControlFramePeriodMs(int periodMs) {
        this.throwIfClosed();
        CANServoHubJNI.c_ServoHub_SetControlFramePeriod(this.servoHubHandle, periodMs);
    }

    public int getControlFramePeriodMs() {
        this.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetControlFramePeriod(this.servoHubHandle);
    }

    public @Nullable PeriodicStatus0 getPeriodicStatus0() {
        this.throwIfClosed();
        PeriodicStatus0 status0 = new PeriodicStatus0();
        boolean success = CANServoHubJNI.c_ServoHub_GetPeriodStatus0(this.servoHubHandle, status0);
        if (!success) {
            return null;
        }
        return status0;
    }

    public @Nullable PeriodicStatus1 getPeriodicStatus1() {
        this.throwIfClosed();
        PeriodicStatus1 status1 = new PeriodicStatus1();
        boolean success = CANServoHubJNI.c_ServoHub_GetPeriodStatus1(this.servoHubHandle, status1);
        if (!success) {
            return null;
        }
        return status1;
    }

    public @Nullable PeriodicStatus2 getPeriodicStatus2() {
        this.throwIfClosed();
        PeriodicStatus2 status2 = new PeriodicStatus2();
        boolean success = CANServoHubJNI.c_ServoHub_GetPeriodStatus2(this.servoHubHandle, status2);
        if (!success) {
            return null;
        }
        return status2;
    }

    public @Nullable PeriodicStatus3 getPeriodicStatus3() {
        this.throwIfClosed();
        PeriodicStatus3 status3 = new PeriodicStatus3();
        boolean success = CANServoHubJNI.c_ServoHub_GetPeriodStatus3(this.servoHubHandle, status3);
        if (!success) {
            return null;
        }
        return status3;
    }

    public @Nullable PeriodicStatus4 getPeriodicStatus4() {
        this.throwIfClosed();
        PeriodicStatus4 status4 = new PeriodicStatus4();
        boolean success = CANServoHubJNI.c_ServoHub_GetPeriodStatus4(this.servoHubHandle, status4);
        if (!success) {
            return null;
        }
        return status4;
    }

    public void createSimFaultManager() {
        CANServoHubJNI.c_ServoHub_CreateSimFaultManager(this.servoHubHandle);
    }

    protected void throwIfClosed() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("This ServoHub object has previously been closed.");
        }
    }

    public class FirmwareVersion {
        private int firmwareFix;
        private int firmwareMinor;
        private int firmwareYear;
        private int hardwareMinor;
        private int hardwareMajor;

        public int getYear() {
            return this.firmwareYear;
        }

        public int getMinor() {
            return this.firmwareMinor;
        }

        public int getFix() {
            return this.firmwareFix;
        }

        public int hardwareMajor() {
            return this.hardwareMajor;
        }

        public int hardwareMinor() {
            return this.hardwareMinor;
        }
    }

    public class PeriodicStatus0 {
        public double voltage;
        public double servoVoltage;
        public double deviceCurrent;
        public boolean primaryHeartbeatLock;
        public boolean systemEnabled;
        public int communicationMode;
        public boolean programmingEnabled;
        public boolean activelyProgramming;
    }

    public class PeriodicStatus1 {
        public boolean regulatorPowerGoodFault;
        public boolean brownout;
        public boolean canWarning;
        public boolean canBusOff;
        public boolean hardwareFault;
        public boolean firmwareFault;
        public boolean hasReset;
        public boolean channel0Overcurrent;
        public boolean channel1Overcurrent;
        public boolean channel2Overcurrent;
        public boolean channel3Overcurrent;
        public boolean channel4Overcurrent;
        public boolean channel5Overcurrent;
        public boolean stickyRegulatorPowerGoodFault;
        public boolean stickyBrownout;
        public boolean stickyCanWarning;
        public boolean stickyCanBusOff;
        public boolean stickyHardwareFault;
        public boolean stickyFirmwareFault;
        public boolean stickyHasReset;
        public boolean stickyChannel0Overcurrent;
        public boolean stickyChannel1Overcurrent;
        public boolean stickyChannel2Overcurrent;
        public boolean stickyChannel3Overcurrent;
        public boolean stickyChannel4Overcurrent;
        public boolean stickyChannel5Overcurrent;
    }

    public class PeriodicStatus2 {
        public short channel0PulseWidth;
        public short channel1PulseWidth;
        public short channel2PulseWidth;
        public boolean channel0Enabled;
        public boolean channel1Enabled;
        public boolean channel2Enabled;
        public boolean channel0OutOfRange;
        public boolean channel1OutOfRange;
        public boolean channel2OutOfRange;
    }

    public class PeriodicStatus3 {
        public short channel3PulseWidth;
        public short channel4PulseWidth;
        public short channel5PulseWidth;
        public boolean channel3Enabled;
        public boolean channel4Enabled;
        public boolean channel5Enabled;
        public boolean channel3OutOfRange;
        public boolean channel4OutOfRange;
        public boolean channel5OutOfRange;
    }

    public class PeriodicStatus4 {
        public double channel0Current;
        public double channel1Current;
        public double channel2Current;
        public double channel3Current;
        public double channel4Current;
        public double channel5Current;
    }
}

