/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkMax;
import edu.wpi.first.hal.SimBoolean;
import edu.wpi.first.hal.SimDouble;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class SparkMaxAlternateEncoderSim {
    private SimDouble m_position;
    private SimDouble m_velocity;
    private SimBoolean m_isInverted;
    private SimDouble m_zeroOffset;
    private SimDouble m_positionConversionFactor;
    private SimDouble m_velocityConversionFactor;
    private SparkBase m_spark;
    private String simDeviceName;

    public SparkMaxAlternateEncoderSim(SparkMax motor) {
        this.simDeviceName = "SPARK MAX [" + motor.getDeviceId() + "] ALTERNATE ENCODER";
        this.setupSimDevice();
    }

    private boolean setupSimDevice() {
        SimDeviceSim alternateEncoderSim = new SimDeviceSim(this.simDeviceName);
        this.m_position = alternateEncoderSim.getDouble("Position");
        this.m_velocity = alternateEncoderSim.getDouble("Velocity");
        this.m_isInverted = alternateEncoderSim.getBoolean("Is Inverted");
        this.m_zeroOffset = alternateEncoderSim.getDouble("Zero Offset");
        this.m_positionConversionFactor = alternateEncoderSim.getDouble("Position Conversion Factor");
        this.m_velocityConversionFactor = alternateEncoderSim.getDouble("Velocity Conversion Factor");
        return this.m_position == null;
    }

    private boolean checkAndSetupSimDevice() {
        if (this.m_position == null) {
            return this.setupSimDevice();
        }
        return false;
    }

    public void setPosition(double position) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_position.set(position);
    }

    public double getPosition() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_position.get();
    }

    public void setVelocity(double velocity) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_velocity.set(velocity);
    }

    public double getVelocity() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_velocity.get();
    }

    public void setInverted(boolean inverted) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_isInverted.set(inverted);
    }

    public boolean getInverted() {
        if (this.checkAndSetupSimDevice()) {
            return false;
        }
        return this.m_isInverted.get();
    }

    public void setZeroOffset(double zeroOffset) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        this.m_zeroOffset.set(zeroOffset);
    }

    public double getZeroOffset() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_zeroOffset.get();
    }

    public double getPositionConversionFactor() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_positionConversionFactor.get();
    }

    public double getVelocityConversionFactor() {
        if (this.checkAndSetupSimDevice()) {
            return 0.0;
        }
        return this.m_velocityConversionFactor.get();
    }

    public void iterate(double velocity, double dt) {
        if (this.checkAndSetupSimDevice()) {
            return;
        }
        double velocityRPM = velocity / this.getVelocityConversionFactor();
        this.m_position.set(this.m_position.get() + velocityRPM / 60.0 * dt * this.getPositionConversionFactor());
    }
}

