/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.config.SparkParameters;

public class ExternalEncoderConfig
extends BaseConfig {
    public ExternalEncoderConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public ExternalEncoderConfig apply(ExternalEncoderConfig config) {
        super.apply(config);
        return this;
    }

    public ExternalEncoderConfig countsPerRevolution(int cpr) {
        this.putParameter(SparkParameters.kAltEncoderCountsPerRev.value, cpr);
        return this;
    }

    public ExternalEncoderConfig inverted(boolean inverted) {
        this.putParameter(SparkParameters.kAltEncoderInverted.value, inverted);
        return this;
    }

    public ExternalEncoderConfig positionConversionFactor(double factor) {
        this.putParameter(SparkParameters.kAltEncoderPositionConversion.value, (float)factor);
        return this;
    }

    public ExternalEncoderConfig velocityConversionFactor(double factor) {
        this.putParameter(SparkParameters.kAltEncoderVelocityConversion.value, (float)factor);
        return this;
    }

    public ExternalEncoderConfig averageDepth(int depth) {
        this.putParameter(SparkParameters.kAltEncoderAverageDepth.value, depth);
        return this;
    }

    public ExternalEncoderConfig measurementPeriod(int periodMs) {
        this.putParameter(SparkParameters.kAltEncoderSampleDelta.value, periodMs);
        return this;
    }

    public static enum Type {
        kQuadrature(0);

        public final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromId(int id) {
            return kQuadrature;
        }
    }

    public static class Presets {
        public static final ExternalEncoderConfig REV_ThroughBoreEncoder = new ExternalEncoderConfig().countsPerRevolution(8192);
        public static final ExternalEncoderConfig REV_ThroughBoreEncoderV2 = new ExternalEncoderConfig().countsPerRevolution(8192);
        public static final ExternalEncoderConfig REV_SplineEncoder = new ExternalEncoderConfig().countsPerRevolution(8192);
    }
}

