/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.config.SparkParameters;

public class SignalsConfig
extends BaseConfig {
    public SignalsConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    private void setPeriodMsCore(int parameterId, int periodMs) {
        Object value = this.getParameter(parameterId);
        if (value == null) {
            this.putParameter(parameterId, periodMs);
        } else {
            int currentPeriodMs = (Integer)value;
            this.putParameter(parameterId, Math.min(currentPeriodMs, periodMs));
        }
    }

    private void setAlwaysOnCore(int parameterId, boolean enabled) {
        if (parameterId == SparkParameters.kForceEnableStatus_0.value) {
            return;
        }
        Object value = this.getParameter(parameterId);
        if (value == null) {
            this.putParameter(parameterId, enabled);
        } else {
            boolean currentValue = (Boolean)value;
            this.putParameter(parameterId, currentValue || enabled);
        }
    }

    public SignalsConfig apply(SignalsConfig config) {
        super.apply(config);
        return this;
    }

    public SignalsConfig appliedOutputPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus0Period.value, periodMs);
        return this;
    }

    @Deprecated
    public SignalsConfig appliedOutputAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_0.value, enabled);
        return this;
    }

    public SignalsConfig busVoltagePeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus0Period.value, periodMs);
        return this;
    }

    @Deprecated
    public SignalsConfig busVoltageAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_0.value, enabled);
        return this;
    }

    public SignalsConfig outputCurrentPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus0Period.value, periodMs);
        return this;
    }

    @Deprecated
    public SignalsConfig outputCurrentAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_0.value, enabled);
        return this;
    }

    public SignalsConfig motorTemperaturePeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus0Period.value, periodMs);
        return this;
    }

    @Deprecated
    public SignalsConfig motorTemperatureAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_0.value, enabled);
        return this;
    }

    public SignalsConfig limitsPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus0Period.value, periodMs);
        return this;
    }

    @Deprecated
    public SignalsConfig limitsAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_0.value, enabled);
        return this;
    }

    public SignalsConfig faultsPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus1Period.value, periodMs);
        return this;
    }

    public SignalsConfig faultsAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_1.value, enabled);
        return this;
    }

    public SignalsConfig warningsPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus1Period.value, periodMs);
        return this;
    }

    public SignalsConfig warningsAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_1.value, enabled);
        return this;
    }

    public SignalsConfig primaryEncoderVelocityPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus2Period.value, periodMs);
        return this;
    }

    public SignalsConfig primaryEncoderVelocityAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_2.value, enabled);
        return this;
    }

    public SignalsConfig primaryEncoderPositionPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus2Period.value, periodMs);
        return this;
    }

    public SignalsConfig primaryEncoderPositionAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_2.value, enabled);
        return this;
    }

    public SignalsConfig analogVoltagePeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus3Period.value, periodMs);
        return this;
    }

    public SignalsConfig analogVoltageAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_3.value, enabled);
        return this;
    }

    public SignalsConfig analogVelocityPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus3Period.value, periodMs);
        return this;
    }

    public SignalsConfig analogVelocityAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_3.value, enabled);
        return this;
    }

    public SignalsConfig analogPositionPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus3Period.value, periodMs);
        return this;
    }

    public SignalsConfig analogPositionAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_3.value, enabled);
        return this;
    }

    public SignalsConfig externalOrAltEncoderVelocity(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus4Period.value, periodMs);
        return this;
    }

    public SignalsConfig externalOrAltEncoderVelocityAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_4.value, enabled);
        return this;
    }

    public SignalsConfig externalOrAltEncoderPosition(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus4Period.value, periodMs);
        return this;
    }

    public SignalsConfig externalOrAltEncoderPositionAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_4.value, enabled);
        return this;
    }

    public SignalsConfig absoluteEncoderVelocityPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus5Period.value, periodMs);
        return this;
    }

    public SignalsConfig absoluteEncoderVelocityAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_5.value, enabled);
        return this;
    }

    public SignalsConfig absoluteEncoderPositionPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus5Period.value, periodMs);
        return this;
    }

    public SignalsConfig absoluteEncoderPositionAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_5.value, enabled);
        return this;
    }

    public SignalsConfig unadjustedDutyCyclePeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus6Period.value, periodMs);
        return this;
    }

    public SignalsConfig unadjustedDutyCyclePeriodAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_6.value, enabled);
        return this;
    }

    public SignalsConfig dutyCyclePeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus6Period.value, periodMs);
        return this;
    }

    public SignalsConfig dutyCyclePeriodAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_6.value, enabled);
        return this;
    }

    public SignalsConfig iAccumulationPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus7Period.value, periodMs);
        return this;
    }

    public SignalsConfig iAccumulationAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_7.value, enabled);
        return this;
    }

    public SignalsConfig setpointPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus8Period.value, periodMs);
        return this;
    }

    public SignalsConfig setSetpointAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_8.value, enabled);
        return this;
    }

    public SignalsConfig isAtSetpointPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus8Period.value, periodMs);
        return this;
    }

    public SignalsConfig isAtSetpointAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_8.value, enabled);
        return this;
    }

    public SignalsConfig selectedSlotPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus8Period.value, periodMs);
        return this;
    }

    public SignalsConfig selectedSlotAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_8.value, enabled);
        return this;
    }

    public SignalsConfig maxMotionSetpointPositionPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus9Period.value, periodMs);
        return this;
    }

    public SignalsConfig maxMotionSetpointPositionAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_9.value, enabled);
        return this;
    }

    public SignalsConfig maxMotionSetpointVelocityPeriodMs(int periodMs) {
        this.setPeriodMsCore(SparkParameters.kStatus9Period.value, periodMs);
        return this;
    }

    public SignalsConfig maxMotionSetpointVelocityAlwaysOn(boolean enabled) {
        this.setAlwaysOnCore(SparkParameters.kForceEnableStatus_9.value, enabled);
        return this;
    }
}

