/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.bootloader.REVUpBootloader;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.dfu.DFUFile;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.exceptions.CANUpdateSessionNotFoundException;
import com.revrobotics.revui.app.exceptions.CANUpdateSessionNotReadyException;
import com.revrobotics.revui.app.exceptions.IllegalDFUFileException;
import com.revrobotics.revui.app.exceptions.REVUpOnlySupportsOneUUIDException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/revup/update/can"})
public class REVUpController {
    @Autowired
    DeviceDaemon deviceDaemon;
    private final Map<Integer, UpdateSession> sessionMap = new ConcurrentHashMap<Integer, UpdateSession>();
    private final AtomicInteger sessionKey = new AtomicInteger(0);

    @PostMapping(value={"/"})
    public int createSession(@PathVariable String descriptor, @RequestBody UUID[] uuids) {
        if (uuids.length != 1) {
            throw new REVUpOnlySupportsOneUUIDException();
        }
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuids[0]);
        return (Integer)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (bridge, bus) -> {
            UpdateSession session = this.createSession(bridge, bus, device);
            return session.id();
        });
    }

    @ApiResponses(value={@ApiResponse(responseCode="200", description="Firmware uploaded successfully"), @ApiResponse(responseCode="404", description="Error: Session not found (sessionId does not exist)"), @ApiResponse(responseCode="500", description="Error: Failed to upload firmware file")})
    @PostMapping(path={"/{sessionId}/upload"}, consumes={"multipart/form-data"})
    public void uploadFirmware(@PathVariable int sessionId, @RequestPart(value="file") MultipartFile file) {
        DFUFile dfu;
        UpdateSession session = this.sessionMap.get(sessionId);
        if (session == null) {
            throw new CANUpdateSessionNotFoundException(sessionId);
        }
        if (session.getStatus() != SessionUpdateStatus.READY_FOR_UPLOAD) {
            throw new CANUpdateSessionNotReadyException(sessionId, session.getStatus());
        }
        session.status.set(SessionUpdateStatus.UPLOADING);
        try {
            dfu = new DFUFile(file.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalDFUFileException();
        }
        DFUFile.DFUImage image = (DFUFile.DFUImage)dfu.images().getFirst();
        if (image.elements().size() < 3) {
            throw new IllegalDFUFileException();
        }
        DFUFile.DFUElement element = (DFUFile.DFUElement)image.elements().get(2);
        session.setFileData(element.data());
    }

    @PostMapping(value={"/{sessionId}/start"})
    public void flashFirmware(@PathVariable int sessionId) {
        UpdateSession session = this.sessionMap.get(sessionId);
        if (session == null) {
            throw new CANUpdateSessionNotFoundException(sessionId);
        }
        if (session.getStatus() == SessionUpdateStatus.COMPLETED) {
            throw new CANUpdateSessionNotReadyException(sessionId, SessionUpdateStatus.COMPLETED);
        }
        if (session.getFileData() == null) {
            throw new CANUpdateSessionNotReadyException(sessionId, session.getStatus());
        }
        REVUpBootloader bootloader = session.bootloader;
        Thread t = new Thread(() -> {
            bootloader.startFlashingApp(session.device.id(), (InputStream)new ByteArrayInputStream(session.getFileData()), 20);
            session.status.set(SessionUpdateStatus.COMPLETED);
        }, "REVUp Flashing Thread");
        t.start();
    }

    @GetMapping(value={"/{id}"})
    public SessionStatusResult getSessionStatus(@PathVariable int id) {
        UpdateSession session = this.sessionMap.get(id);
        if (session == null) {
            throw new CANUpdateSessionNotFoundException(id);
        }
        return new SessionStatusResult(session.getStatus(), session.getPercentage());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteSession(@PathVariable int id) {
        UpdateSession session = this.sessionMap.get(id);
        if (session == null) {
            throw new CANUpdateSessionNotFoundException(id);
        }
        this.sessionMap.remove(id);
    }

    private UpdateSession createSession(CanBridge bridge, CanBus bus, FRCCanDevice device) {
        int newId = this.sessionKey.getAndIncrement();
        int deviceType = REVUpController.getDeviceTypeFromRecognizedDevice(device.type());
        REVUpBootloader bootloader = new REVUpBootloader(bridge, bus, deviceType);
        UpdateSession session = new UpdateSession(bootloader, newId, device);
        this.sessionMap.put(session.id(), session);
        return session;
    }

    private static int getDeviceTypeFromRecognizedDevice(RecognizedDevice type) {
        return switch (type) {
            case RecognizedDevice.PDH -> 8;
            case RecognizedDevice.PH -> 9;
            case RecognizedDevice.SERVO_HUB -> 12;
            case RecognizedDevice.MAXSPLINE_ENCODER -> 7;
            default -> throw new WrongDeviceTypeException();
        };
    }

    private static final class UpdateSession {
        private final REVUpBootloader bootloader;
        private final int id;
        private final FRCCanDevice device;
        private byte[] fileData;
        private final AtomicReference<SessionUpdateStatus> status = new AtomicReference<SessionUpdateStatus>(SessionUpdateStatus.READY_FOR_UPLOAD);

        private UpdateSession(REVUpBootloader bootloader, int id, FRCCanDevice device) {
            this.bootloader = bootloader;
            this.id = id;
            this.device = device;
        }

        SessionUpdateStatus getStatus() {
            REVUpBootloader.REVUpUpdateStatus bootloaderStatus = this.bootloader.getStatus();
            if (bootloaderStatus == REVUpBootloader.REVUpUpdateStatus.IDLE) {
                return this.status.get();
            }
            return SessionUpdateStatus.fromBootloaderStatus(bootloaderStatus);
        }

        int getPercentage() {
            return this.bootloader.getPercentage();
        }

        public REVUpBootloader bootloader() {
            return this.bootloader;
        }

        public int id() {
            return this.id;
        }

        public FRCCanDevice device() {
            return this.device;
        }

        void setFileData(byte[] fileData) {
            this.fileData = fileData;
            this.status.set(SessionUpdateStatus.READY_TO_FLASH);
        }

        byte[] getFileData() {
            return this.fileData;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UpdateSession that = (UpdateSession)obj;
            return Objects.equals(this.bootloader, that.bootloader) && this.id == that.id && Objects.equals(this.device, that.device);
        }

        public int hashCode() {
            return Objects.hash(this.bootloader, this.id, this.device);
        }

        public String toString() {
            return "UpdateSession[bootloader=" + String.valueOf(this.bootloader) + ", id=" + this.id + ", device=" + String.valueOf(this.device) + "]";
        }
    }

    public static enum SessionUpdateStatus {
        FAILED,
        READY_TO_FLASH,
        READY_FOR_UPLOAD,
        UPLOADING,
        ENTERING_BOOTLOADER,
        INITIALIZING,
        FLASHING,
        EXITING_BOOTLOADER,
        COMPLETED;


        public static SessionUpdateStatus fromBootloaderStatus(REVUpBootloader.REVUpUpdateStatus status) {
            return switch (status) {
                case REVUpBootloader.REVUpUpdateStatus.ENTERING_BOOTLOADER -> ENTERING_BOOTLOADER;
                case REVUpBootloader.REVUpUpdateStatus.INITIALIZING -> INITIALIZING;
                case REVUpBootloader.REVUpUpdateStatus.SENDING_BINARY -> FLASHING;
                case REVUpBootloader.REVUpUpdateStatus.EXITING_BOOTLOADER -> EXITING_BOOTLOADER;
                case REVUpBootloader.REVUpUpdateStatus.DONE -> COMPLETED;
                default -> FAILED;
            };
        }
    }

    public record SessionStatusResult(SessionUpdateStatus status, int percentage) {
    }
}

