/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.executable.ExecutableFinder;
import com.revrobotics.revui.app.files.DirectoryManager;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jspecify.annotations.NonNull;

public class SetDriverForDfu {
    private static final Logger logger = Logger.getLogger(SetDriverForDfu.class.getName());

    private static List<String> getWdiSimpleArgs() {
        Path wdiSimplePath = ExecutableFinder.findExecutable((String)"wdi-simple");
        return List.of(wdiSimplePath.toString(), "--vid", "0x0483", "--pid", "0xDF11", "--type", "0", "--silent", "--timeout", "120000", "-l", "0");
    }

    public static boolean setDriverForDfu(boolean doAsAdmin) {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            logger.info("Refusing to set Windows driver on " + System.getProperty("os.name"));
            return true;
        }
        Path wdiSimplePath = ExecutableFinder.findExecutable((String)"wdi-simple");
        try {
            ProcessBuilder processBuilder = SetDriverForDfu.createSetDriverProcess(doAsAdmin, wdiSimplePath);
            Process process = processBuilder.start();
            logger.info(String.join((CharSequence)" ", processBuilder.command().toArray(new String[0])));
            int result = process.waitFor();
            String resultText = new String(process.getInputStream().readAllBytes());
            String errorText = new String(process.getErrorStream().readAllBytes());
            logger.info("stdout:\n" + resultText);
            logger.info("stderr:\n" + errorText);
            logger.info("Result of wdi-simple: " + result);
            return result == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (IOException e) {
            logger.severe("Failed to set driver for DFU: " + e.getMessage());
            return false;
        }
    }

    private static @NonNull ProcessBuilder createSetDriverProcess(boolean doAsAdmin, Path wdiSimplePath) throws IOException {
        List<String> args = SetDriverForDfu.getWdiSimpleArgs();
        if (doAsAdmin) {
            Path dir = DirectoryManager.getExecutableDirectory();
            Path tempExe = Files.createTempFile(dir, "wdi-simple-", ".exe", new FileAttribute[0]);
            Files.copy(wdiSimplePath, tempExe, StandardCopyOption.REPLACE_EXISTING);
            tempExe.toFile().deleteOnExit();
            args = args.subList(1, args.size());
            String argsString = String.join((CharSequence)" ", args);
            args = new ArrayList<CallSite>(List.of("powershell.exe", "-command", "Start-Process -Wait -WindowStyle Hidden -FilePath '" + String.valueOf(tempExe) + "' -Verb RunAs -ArgumentList '" + argsString + "'"));
        }
        return new ProcessBuilder(args);
    }
}

