/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.download;

import ca.gosyer.appdirs.AppDirs;
import com.revrobotics.revui.app.download.DownloadContext;
import com.revrobotics.revui.app.download.db.DownloadChannel;
import com.revrobotics.revui.app.download.db.DownloadChannelRepository;
import com.revrobotics.revui.app.download.db.DownloadModel;
import com.revrobotics.revui.app.download.db.DownloadRepository;
import com.revrobotics.revui.app.download.metadata.repo.MetadataHandler;
import com.revrobotics.revui.app.download.metadata.repo.model.Channel;
import com.revrobotics.revui.app.download.metadata.repo.model.Metadata;
import com.revrobotics.revui.app.download.metadata.repo.model.SoftwareEntry;
import com.revrobotics.revui.app.files.DirectoryManager;
import jakarta.transaction.Transactional;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.orm.jpa.JpaSystemException;

public class DownloadManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static AppDirs appDirs;
    private static HttpClient httpClient;
    private final DownloadRepository repository;
    private final DownloadChannelRepository downloadChannelRepository;

    public DownloadManager(DownloadRepository repository, DownloadChannelRepository downloadChannelRepository) {
        this.repository = repository;
        this.downloadChannelRepository = downloadChannelRepository;
    }

    private static HttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void syncDatabaseFiles() {
        DownloadRepository downloadRepository = this.repository;
        synchronized (downloadRepository) {
            Metadata metadata;
            long startTime = System.currentTimeMillis();
            this.repository.deleteAll();
            try {
                metadata = MetadataHandler.getMetadata();
            }
            catch (IOException e) {
                return;
            }
            this.syncDatabaseFilesForContext(metadata, DownloadContext.SPARK_MAX);
            this.syncDatabaseFilesForContext(metadata, DownloadContext.SPARK_FLEX);
            this.syncDatabaseFilesForContext(metadata, DownloadContext.PDH);
            this.syncDatabaseFilesForContext(metadata, DownloadContext.PH);
            this.syncDatabaseFilesForContext(metadata, DownloadContext.SERVO_HUB);
            this.syncDatabaseFilesForContext(metadata, DownloadContext.MAXSPLINE_ENCODER);
            long endTime = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Took " + (endTime - startTime) + "ms to synchronize download database");
        }
    }

    public void deleteFile(String path) {
        try {
            Files.delete(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Transactional
    void syncDatabaseFilesForContext(Metadata metadata, DownloadContext context) {
        List<SoftwareEntry> softwares = MetadataHandler.getSoftwareEntries(metadata, context);
        for (SoftwareEntry software : softwares) {
            Path downloadPath = this.getPathForSoftware(software);
            System.out.println(downloadPath);
            Set<DownloadChannel> channels = software.channels().stream().map(this.downloadChannelRepository::findByCode).filter(Objects::nonNull).collect(Collectors.toSet());
            if (channels.isEmpty() && !software.version().isPublic()) continue;
            boolean isDownloaded = Files.exists(downloadPath, new LinkOption[0]);
            DownloadModel model = new DownloadModel(null, downloadPath.toAbsolutePath().toString(), software.url(), isDownloaded, context, software.sha256(), software.releaseNotes(), channels, software.version().major(), software.version().minor(), software.version().fix(), software.version().prerelease());
            try {
                this.repository.save(model);
            }
            catch (JpaSystemException e) {
                System.err.println("Failed to save model: " + e.getMessage());
            }
        }
    }

    public DownloadChannel createChannel(String code) {
        Metadata metadata;
        if (code == null) {
            return null;
        }
        try {
            metadata = MetadataHandler.getMetadata();
        }
        catch (IOException e) {
            return null;
        }
        Optional<Channel> metadataChannel = metadata.channels().stream().filter(channel -> code.equals(channel.code())).findFirst();
        if (metadataChannel.isEmpty()) {
            return null;
        }
        DownloadChannel existing = this.downloadChannelRepository.findByCode(code);
        if (existing != null) {
            return existing;
        }
        Channel channel2 = metadataChannel.get();
        DownloadChannel newChannel = new DownloadChannel(null, channel2.name(), channel2.code(), channel2.isPublic());
        return (DownloadChannel)this.downloadChannelRepository.save(newChannel);
    }

    public DownloadState downloadSoftwareIfNeeded(Path path, URI uri, String sha256) {
        if (!Files.exists(path, new LinkOption[0])) {
            HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(60L)).GET().build();
            try {
                HttpResponse<Path> response = DownloadManager.getHttpClient().send(request, HttpResponse.BodyHandlers.ofFile(path));
                boolean shaMatches = this.matchesSha(path, sha256);
                if (!shaMatches) {
                    Files.delete(path);
                    return DownloadState.MISMATCHED_SHA;
                }
                if (response.statusCode() != 200) {
                    return DownloadState.FAILED_TO_DOWNLOAD;
                }
                return DownloadState.DOWNLOADED;
            }
            catch (IOException | InterruptedException e) {
                return DownloadState.FAILED_TO_DOWNLOAD;
            }
        }
        return DownloadState.ALREADY_EXISTS;
    }

    Path getPathForSoftware(SoftwareEntry software) {
        String filename = String.valueOf((Object)software.context()) + "-" + software.version().toString() + "-" + software.sha256().substring(0, 10) + ".dfu";
        return DirectoryManager.getDownloadsPath().resolve(filename);
    }

    private boolean matchesSha(Path path, String sha256) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(path);
            byte[] hash = digest.digest(fileBytes);
            String hexHash = DownloadManager.bytesToHex(hash);
            return hexHash.equalsIgnoreCase(sha256);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return false;
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static enum DownloadState {
        ALREADY_EXISTS(true),
        DOWNLOADED(true),
        FAILED_TO_DOWNLOAD(false),
        MISMATCHED_SHA(false);

        private final boolean isSuccess;

        private DownloadState(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }
    }
}

