/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.ui;

import com.revrobotics.revui.app.SettingsController;
import com.revrobotics.revui.app.files.DirectoryManager;
import com.revrobotics.revui.app.ui.AppSplashScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import me.friwi.jcefmaven.CefAppBuilder;
import me.friwi.jcefmaven.CefInitializationException;
import me.friwi.jcefmaven.IProgressHandler;
import me.friwi.jcefmaven.MavenCefAppHandlerAdapter;
import me.friwi.jcefmaven.UnsupportedPlatformException;
import me.friwi.jcefmaven.impl.progress.ConsoleProgressHandler;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;

public class Window {
    private static final Logger logger = Logger.getLogger(Window.class.getName());
    private static Window instance;
    private JFrame frame;

    public static Window getInstance() {
        if (instance == null) {
            instance = new Window();
        }
        return instance;
    }

    private Window() {
        Window.logInfo();
    }

    public void start(int port) {
        SettingsController.Theme theme;
        CefApp app;
        try {
            app = this.initClient();
        }
        catch (IOException | InterruptedException | CefInitializationException | UnsupportedPlatformException e) {
            throw new RuntimeException(e);
        }
        CefClient client = app.createClient();
        final CefBrowser browser = client.createBrowser("http://localhost:" + port + "?port=" + port, false, false);
        AppSplashScreen.closeSplashScreen();
        final Component browserUi = browser.getUIComponent();
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(800, 600);
        this.frame.setExtendedState(6);
        this.frame.setUndecorated(false);
        this.frame.setTitle("REV Hardware Client 2");
        SettingsController.Theme theme2 = theme = SettingsController.getTheme();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LIGHT", "DEFAULT", "DARK"}, (SettingsController.Theme)theme2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: 
            case 0: 
            case 1: {
                this.setIcon(IconType.LIGHT);
                break;
            }
            case 2: {
                this.setIcon(IconType.DARK);
            }
        }
        browser.setFocus(true);
        this.frame.setLayout(new BorderLayout());
        this.frame.add(browserUi, "Center");
        this.frame.setVisible(true);
        this.frame.toFront();
        SwingUtilities.invokeLater(() -> browserUi.setSize(this.frame.getContentPane().getSize()));
        client.addKeyboardHandler((CefKeyboardHandler)new CefKeyboardHandlerAdapter(this){

            public boolean onKeyEvent(CefBrowser thisBrowserInstance, CefKeyboardHandler.CefKeyEvent event) {
                boolean isAltPressed;
                boolean isShiftPressed = (event.modifiers & 2) != 0;
                boolean bl = isAltPressed = (event.modifiers & 8) != 0;
                if (isShiftPressed && isAltPressed && event.character == 'I') {
                    browser.openDevTools();
                }
                return false;
            }
        });
        client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
                if (fullscreen) {
                    browserUi.setSize(Window.this.frame.getContentPane().getSize());
                }
            }
        });
        client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(this){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                browserUi.invalidate();
                browserUi.repaint();
            }
        });
        client.addContextMenuHandler((CefContextMenuHandler)new CefContextMenuHandlerAdapter(this){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                model.clear();
                if (params.getSelectionText() != null && !params.getSelectionText().isEmpty()) {
                    model.addItem(112, "Cut");
                    model.addItem(113, "Copy");
                }
                if (params.isEditable()) {
                    model.addItem(114, "Paste");
                }
            }
        });
        client.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(this){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String targetUrl, String targetFrameName) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI(targetUrl));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
        this.frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                CefApp.getInstance().dispose();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((CefClient)client).dispose()));
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                browserUi.setSize(Window.this.frame.getContentPane().getSize());
                browserUi.revalidate();
                browserUi.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                browserUi.revalidate();
                browserUi.repaint();
            }
        });
    }

    CefApp initClient() throws UnsupportedPlatformException, CefInitializationException, IOException, InterruptedException {
        CefAppBuilder builder = new CefAppBuilder();
        Path jcefDir = Window.getJcefDir();
        builder.setInstallDir(jcefDir.toFile());
        builder.setProgressHandler((IProgressHandler)new ConsoleProgressHandler());
        builder.getCefSettings().windowless_rendering_enabled = false;
        builder.getCefSettings().cache_path = DirectoryManager.getLocalStoragePath().toAbsolutePath().toString();
        builder.setAppHandler(new MavenCefAppHandlerAdapter(this){});
        return builder.build();
    }

    public void setIcon(IconType icon) {
        String iconPath = switch (icon.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "/RHCV2_Icon_Org_256px.png";
            case 1 -> "/RHCV2_Icon_Blk_256px.png";
            case 2 -> "/RHCV2_Icon_Blu_256px.png";
        };
        Image iconImage = this.loadIconImage(iconPath);
        this.frame.setIconImage(iconImage);
    }

    Image loadIconImage(String icon) {
        URL url = this.getClass().getResource(icon);
        if (url == null) {
            throw new IllegalStateException("Couldn't find icon image");
        }
        return new ImageIcon(url).getImage();
    }

    private static Path getJcefDir() {
        String appDir = System.getProperty("app.dir");
        if (appDir == null) {
            return Paths.get("./jcef-bundle", new String[0]);
        }
        String os = System.getProperty("os.name").toLowerCase();
        Path appDirPath = Paths.get(appDir, new String[0]);
        if (os.startsWith("mac")) {
            Path jcefDir = appDirPath.resolve("../Frameworks").normalize();
            if (!Files.exists(jcefDir.resolve("jcef Helper.app"), new LinkOption[0])) {
                throw new IllegalStateException("jcef Helper.app not found");
            }
            return jcefDir;
        }
        if (os.startsWith("windows")) {
            Path jcefDir = appDirPath.resolve("jcef");
            if (!Files.exists(jcefDir.resolve("jcef.dll"), new LinkOption[0])) {
                throw new IllegalStateException("jcef.dll not found");
            }
            return jcefDir;
        }
        Path jcefDir = appDirPath.resolve("jcef");
        if (!Files.exists(jcefDir.resolve("libjcef.so"), new LinkOption[0])) {
            throw new IllegalStateException("libjcef.so not found");
        }
        return jcefDir;
    }

    private static void logInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String sessionType = System.getenv("XDG_SESSION_TYPE");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screen = ge.getDefaultScreenDevice();
        int numDisplays = ge.getScreenDevices().length;
        DisplayMode dm = screen.getDisplayMode();
        int width = dm.getWidth();
        int height = dm.getHeight();
        GraphicsConfiguration gc = screen.getDefaultConfiguration();
        AffineTransform tx = gc.getDefaultTransform();
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        OSScreenInfo osInfo = new OSScreenInfo(osName, osVersion, osArch, numDisplays, width, height, scaleX, scaleY, dpi, sessionType, System.getenv("XDG_CURRENT_DESKTOP"), System.getenv("DESKTOP_SESSION"));
        logger.info("OS Info: " + String.valueOf(osInfo));
    }

    public static enum IconType {
        LIGHT,
        DARK,
        BETA;

    }

    record OSScreenInfo(String name, String version, String arch, int numDisplays, int width, int height, double scaleX, double scaleY, int dpi, String sessionType, String xdgDesktopSession, String desktopSession) {
    }
}

