/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class StatusFrameEmitter {
    private static final long startTime = System.currentTimeMillis();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, this::threadFactory);
    private ScheduledFuture<?> emitterTask;
    private final OnStopCallback onStopCallback;
    protected final boolean[] frameEnabled;

    StatusFrameEmitter(OnStopCallback onStopCallback, int numStatusFrames) {
        this.onStopCallback = onStopCallback;
        this.frameEnabled = new boolean[numStatusFrames];
        this.frameEnabled[0] = true;
    }

    public int getStatusFrameCount() {
        return this.frameEnabled.length;
    }

    public void setFrameEnabled(int index, boolean enabled) {
        if (index >= 0 && index < this.frameEnabled.length) {
            this.frameEnabled[index] = enabled;
        }
    }

    public abstract void runFrameEmitter();

    protected abstract String getThreadName();

    public void start() {
        this.emitterTask = this.scheduler.scheduleAtFixedRate(this::runFrameEmitter, 0L, this.getFramePeriodMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        try {
            this.onStopCallback.onStop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.emitterTask.cancel(false);
        this.emitterTask = null;
        this.scheduler.close();
    }

    public boolean isRunning() {
        return this.emitterTask != null && !this.emitterTask.isDone();
    }

    protected double getTimestamp() {
        long timeMs = System.currentTimeMillis() - startTime;
        return (double)timeMs / 1000.0;
    }

    protected int getFramePeriodMilliseconds() {
        return 20;
    }

    private Thread threadFactory(Runnable runnable) {
        Thread t = new Thread(runnable, this.getThreadName());
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public static interface OnStopCallback {
        public void onStop() throws IOException;
    }
}

