/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.jdbc.Expectations;

public interface Expectation {
    default public boolean canBeBatched() {
        return true;
    }

    default public int getNumberOfParametersUsed() {
        return 0;
    }

    public void verifyOutcome(int var1, PreparedStatement var2, int var3, String var4) throws SQLException, HibernateException;

    default public int prepare(PreparedStatement statement) throws SQLException, HibernateException {
        return 0;
    }

    default public void validate(boolean callable) throws MappingException {
    }

    public static class OutParameter
    implements Expectation {
        @Override
        public final void verifyOutcome(int rowCount, PreparedStatement statement, int batchPosition, String sql) {
            int result;
            try {
                result = Expectations.toCallableStatement(statement).getInt(this.parameterIndex());
            }
            catch (SQLException sqle) {
                Expectations.sqlExceptionHelper.logExceptions(sqle, "Could not extract row count from CallableStatement");
                throw new GenericJDBCException("Could not extract row count from CallableStatement", sqle);
            }
            if (batchPosition < 0) {
                Expectations.checkNonBatched(this.expectedRowCount(), result, sql);
            } else {
                Expectations.checkBatched(this.expectedRowCount(), result, batchPosition, sql);
            }
        }

        @Override
        public void validate(boolean callable) throws MappingException {
            if (!callable) {
                throw new MappingException("Expectation.OutParameter operates exclusively on CallableStatements");
            }
        }

        @Override
        public int getNumberOfParametersUsed() {
            return 1;
        }

        @Override
        public int prepare(PreparedStatement statement) throws SQLException, HibernateException {
            Expectations.toCallableStatement(statement).registerOutParameter(this.parameterIndex(), 2);
            return 1;
        }

        @Override
        public boolean canBeBatched() {
            return false;
        }

        protected int parameterIndex() {
            return 1;
        }

        protected int expectedRowCount() {
            return 1;
        }
    }

    public static class RowCount
    implements Expectation {
        @Override
        public final void verifyOutcome(int rowCount, PreparedStatement statement, int batchPosition, String sql) {
            if (batchPosition < 0) {
                Expectations.checkNonBatched(this.expectedRowCount(), rowCount, sql);
            } else {
                Expectations.checkBatched(this.expectedRowCount(), rowCount, batchPosition, sql);
            }
        }

        protected int expectedRowCount() {
            return 1;
        }
    }

    public static class None
    implements Expectation {
        public static final None INSTANCE = new None();

        @Override
        public void verifyOutcome(int rowCount, PreparedStatement statement, int batchPosition, String sql) {
        }
    }
}

