/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractMultiNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class MultiNaturalIdLoaderArrayParam<E>
extends AbstractMultiNaturalIdLoader<E>
implements SqlArrayMultiKeyLoader {
    private final Class<?> keyClass;

    public MultiNaturalIdLoaderArrayParam(EntityMappingType entityDescriptor) {
        super(entityDescriptor);
        assert (entityDescriptor.getNaturalIdMapping() instanceof SimpleNaturalIdMapping);
        this.keyClass = entityDescriptor.getNaturalIdMapping().getJavaType().getJavaTypeClass();
    }

    protected SimpleNaturalIdMapping getNaturalIdMapping() {
        return (SimpleNaturalIdMapping)this.getEntityDescriptor().getNaturalIdMapping();
    }

    protected BasicAttributeMapping getNaturalIdAttribute() {
        return (BasicAttributeMapping)this.getNaturalIdMapping().asAttributeMapping();
    }

    @Override
    public List<E> loadEntitiesWithUnresolvedIds(Object[] naturalIds, MultiNaturalIdLoadOptions loadOptions, final LockOptions lockOptions, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        JdbcMapping arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping(this.getNaturalIdMapping().getSingleJdbcMapping(), this.keyClass, factory);
        JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(arrayJdbcMapping);
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter(this.getLoadable(), this.getNaturalIdAttribute(), session.getLoadQueryInfluencers(), lockOptions, jdbcParameter, factory);
        JdbcOperationQuerySelect jdbcSelectOperation = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, new QueryOptionsAdapter(){

            @Override
            public LockOptions getLockOptions() {
                return lockOptions;
            }
        });
        return LoaderHelper.loadByArrayParameter(LoaderHelper.normalizeKeys(naturalIds, this.getNaturalIdAttribute(), session, factory), sqlAst, jdbcSelectOperation, jdbcParameter, arrayJdbcMapping, null, null, null, lockOptions, session.isDefaultReadOnly(), session);
    }
}

