/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.builder.AbstractRestrictedTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilder;

public abstract class AbstractTableUpdateBuilder<O extends MutationOperation>
extends AbstractRestrictedTableMutationBuilder<O, RestrictedTableMutation<O>>
implements TableUpdateBuilder<O> {
    private final List<ColumnValueBinding> keyBindings = new ArrayList<ColumnValueBinding>();
    private final List<ColumnValueBinding> valueBindings = new ArrayList<ColumnValueBinding>();
    private List<ColumnValueBinding> lobValueBindings;
    private String sqlComment;

    public AbstractTableUpdateBuilder(MutationTarget<?> mutationTarget, TableMapping tableMapping, SessionFactoryImplementor sessionFactory) {
        super(MutationType.UPDATE, mutationTarget, tableMapping, sessionFactory);
        this.sqlComment = "update for " + mutationTarget.getRolePath();
    }

    public AbstractTableUpdateBuilder(MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory) {
        super(MutationType.UPDATE, mutationTarget, tableReference, sessionFactory);
    }

    public String getSqlComment() {
        return this.sqlComment;
    }

    public void setSqlComment(String sqlComment) {
        this.sqlComment = sqlComment;
    }

    protected List<ColumnValueBinding> getKeyBindings() {
        return this.keyBindings;
    }

    protected List<ColumnValueBinding> getValueBindings() {
        return this.valueBindings;
    }

    protected List<ColumnValueBinding> getLobValueBindings() {
        return this.lobValueBindings;
    }

    @Override
    public void addValueColumn(String columnWriteFragment, SelectableMapping selectableMapping) {
        ColumnValueBinding valueBinding = this.createValueBinding(columnWriteFragment, selectableMapping);
        if (selectableMapping.isLob() && this.getJdbcServices().getDialect().forceLobAsLastValue()) {
            if (this.lobValueBindings == null) {
                this.lobValueBindings = new ArrayList<ColumnValueBinding>();
            }
            this.lobValueBindings.add(valueBinding);
        } else {
            this.valueBindings.add(valueBinding);
        }
    }

    @Override
    public void addValueColumn(ColumnValueBinding valueBinding) {
        this.valueBindings.add(valueBinding);
    }

    @Override
    public void addKeyColumn(String columnWriteFragment, SelectableMapping selectableMapping) {
        this.addColumn(columnWriteFragment, selectableMapping, this.keyBindings);
    }
}

