/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.Tuple;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaResultConverters;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.jpa.util.TupleBackedMap;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.util.ConcurrentLruCache;

public class AotRepositoryFragmentSupport {
    private static final ConversionService CONVERSION_SERVICE;
    private final RepositoryMetadata repositoryMetadata;
    private final ValueExpressionDelegate valueExpressions;
    private final ProjectionFactory projectionFactory;
    private final Lazy<ConcurrentLruCache<DeclaredQuery, QueryEnhancer>> enhancers;
    private final Lazy<ConcurrentLruCache<String, ValueExpression>> expressions;
    private final Lazy<ConcurrentLruCache<Method, ValueEvaluationContextProvider>> contextProviders;

    static {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((Converter)JpaResultConverters.BlobToByteArrayConverter.INSTANCE);
        conversionService.removeConvertible(Collection.class, Object.class);
        conversionService.removeConvertible(Object.class, Optional.class);
        CONVERSION_SERVICE = conversionService;
    }

    protected AotRepositoryFragmentSupport(QueryEnhancerSelector selector, RepositoryFactoryBeanSupport.FragmentCreationContext context) {
        this(selector, context.getRepositoryMetadata(), context.getValueExpressionDelegate(), context.getProjectionFactory());
    }

    protected AotRepositoryFragmentSupport(QueryEnhancerSelector selector, RepositoryMetadata repositoryMetadata, ValueExpressionDelegate valueExpressions, ProjectionFactory projectionFactory) {
        this.repositoryMetadata = repositoryMetadata;
        this.valueExpressions = valueExpressions;
        this.projectionFactory = projectionFactory;
        this.enhancers = Lazy.of(() -> new ConcurrentLruCache(32, query -> selector.select((DeclaredQuery)query).create((QueryProvider)query)));
        this.expressions = Lazy.of(() -> new ConcurrentLruCache(32, arg_0 -> ((ValueExpressionDelegate)valueExpressions).parse(arg_0)));
        this.contextProviders = Lazy.of(() -> new ConcurrentLruCache(32, it -> valueExpressions.createValueContextProvider((Parameters)new JpaParameters(ParametersSource.of((RepositoryMetadata)repositoryMetadata, (Method)it)))));
    }

    protected String rewriteQuery(DeclaredQuery query, Sort sort, Class<?> returnedType) {
        QueryEnhancer queryStringEnhancer = (QueryEnhancer)((ConcurrentLruCache)this.enhancers.get()).get((Object)query);
        return queryStringEnhancer.rewrite(new DefaultQueryRewriteInformation(sort, ReturnedType.of(returnedType, (Class)this.repositoryMetadata.getDomainType(), (ProjectionFactory)this.projectionFactory)));
    }

    @Nullable
    protected Object evaluateExpression(Method method, String expressionString, Object ... args) {
        ValueExpression expression = (ValueExpression)((ConcurrentLruCache)this.expressions.get()).get((Object)expressionString);
        ValueEvaluationContextProvider contextProvider = (ValueEvaluationContextProvider)((ConcurrentLruCache)this.contextProviders.get()).get((Object)method);
        return expression.evaluate(contextProvider.getEvaluationContext((Object)args, expression.getExpressionDependencies()));
    }

    @Nullable
    protected Object mapIgnoreCase(@Nullable Object source, UnaryOperator<String> mapper) {
        ArrayList<Object> result;
        if (source == null) {
            return null;
        }
        if (source.getClass().isArray()) {
            int length = Array.getLength(source);
            result = new ArrayList<Object>(length);
            int i = 0;
            while (i < length) {
                result.add(Array.get(source, i));
                ++i;
            }
            source = result;
        }
        if (source instanceof Collection) {
            Collection c = source;
            result = new ArrayList(c.size());
            for (Object o : c) {
                if (o instanceof String) {
                    String s = (String)o;
                    result.add(mapper.apply(s));
                    continue;
                }
                result.add(o != null ? (Object)mapper.apply(o.toString()) : null);
            }
            return result;
        }
        return source;
    }

    protected <T> @Nullable T convertOne(@Nullable Object result, boolean nativeQuery, Class<T> projection) {
        Object object;
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return projection.cast(result);
        }
        if (CONVERSION_SERVICE.canConvert(result.getClass(), projection)) {
            return (T)CONVERSION_SERVICE.convert(result, projection);
        }
        if (result instanceof Tuple) {
            Tuple t = (Tuple)result;
            object = new TupleBackedMap(nativeQuery ? TupleBackedMap.underscoreAware(t) : t);
        } else {
            object = result;
        }
        return (T)this.projectionFactory.createProjection(projection, object);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    protected Object convertMany(@Nullable Object result, boolean nativeQuery, Class<?> projection) {
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return result;
        }
        if (result instanceof Stream) {
            Stream stream = (Stream)result;
            return stream.map(it -> this.convertOne(it, nativeQuery, projection));
        }
        if (result instanceof Slice) {
            Slice slice = (Slice)result;
            return slice.map(it -> this.convertOne(it, nativeQuery, projection));
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            @Nullable Collection target = CollectionFactory.createCollection(collection.getClass(), (int)collection.size());
            for (Object o : collection) {
                target.add(this.convertOne(o, nativeQuery, projection));
            }
            return target;
        }
        throw new UnsupportedOperationException("Cannot create projection for %s".formatted(result));
    }

    private record DefaultQueryRewriteInformation(Sort sort, ReturnedType returnedType) implements QueryEnhancer.QueryRewriteInformation
    {
        @Override
        public Sort getSort() {
            return this.sort();
        }

        @Override
        public ReturnedType getReturnedType() {
            return this.returnedType();
        }
    }
}

