/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

class JpaKeysetScrollQueryCreator
extends JpaQueryCreator {
    private final Metamodel metamodel;
    private final JpaEntityInformation<?, ?> entityInformation;
    private final KeysetScrollPosition scrollPosition;
    private final ParameterMetadataProvider provider;
    private final List<ParameterBinding> syntheticBindings = new ArrayList<ParameterBinding>();

    public JpaKeysetScrollQueryCreator(PartTree tree, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, JpaEntityInformation<?, ?> entityInformation, KeysetScrollPosition scrollPosition, EntityManager em) {
        super(tree, false, type, provider, templates, entityInformation, em.getMetamodel());
        this.metamodel = em.getMetamodel();
        this.entityInformation = entityInformation;
        this.scrollPosition = scrollPosition;
        this.provider = provider;
    }

    @Override
    public List<ParameterBinding> getBindings() {
        List<ParameterBinding> partTreeBindings = super.getBindings();
        ArrayList<ParameterBinding> bindings = new ArrayList<ParameterBinding>(partTreeBindings.size() + this.syntheticBindings.size());
        bindings.addAll(partTreeBindings);
        bindings.addAll(this.syntheticBindings);
        return bindings;
    }

    @Override
    protected JpqlQueryBuilder.AbstractJpqlQuery createQuery( @Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        KeysetScrollSpecification keysetSpec = new KeysetScrollSpecification(this.scrollPosition, sort, this.entityInformation);
        JpqlQueryBuilder.Select query = this.buildQuery(keysetSpec.sort());
        LinkedHashMap cachedBindings = new LinkedHashMap();
        JpqlQueryBuilder.Predicate keysetPredicate = keysetSpec.createJpqlPredicate(this.metamodel, this.getFrom(), this.getEntity(), (property, value) -> {
            Map bindings = cachedBindings.computeIfAbsent(property, k -> new LinkedHashMap());
            ParameterBinding parameterBinding = bindings.computeIfAbsent(value, o -> {
                ParameterBinding binding = this.provider.nextSynthetic(JpaKeysetScrollQueryCreator.sanitize(property), value, this.scrollPosition);
                this.syntheticBindings.add(binding);
                return binding;
            });
            return this.placeholder(parameterBinding);
        });
        JpqlQueryBuilder.Predicate predicateToUse = JpaKeysetScrollQueryCreator.getPredicate(predicate, keysetPredicate);
        if (predicateToUse != null) {
            return query.where(predicateToUse);
        }
        return query;
    }

    private static String sanitize(String property) {
        StringBuilder buffer = new StringBuilder(10 + property.length());
        buffer.append("keyset_");
        char[] charArray = property.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (buffer.length() > 24) break;
            if (Character.isDigit(charArray[i]) || Character.isLetter(charArray[i])) {
                buffer.append(charArray[i]);
            } else if (charArray[i] == '.') {
                buffer.append('_');
            }
            ++i;
        }
        return buffer.toString();
    }

    private static  @Nullable JpqlQueryBuilder.Predicate getPredicate( @Nullable JpqlQueryBuilder.Predicate predicate,  @Nullable JpqlQueryBuilder.Predicate keysetPredicate) {
        if (keysetPredicate != null) {
            if (predicate != null) {
                return predicate.nest().and(keysetPredicate.nest());
            }
            return keysetPredicate;
        }
        return predicate;
    }

    @Override
    Collection<String> getRequiredSelection(Sort sort, ReturnedType returnedType) {
        Sort sortToUse = KeysetScrollSpecification.createSort(this.scrollPosition, sort, this.entityInformation);
        return KeysetScrollDelegate.getProjectionInputProperties(this.entityInformation, returnedType.getInputProperties(), sortToUse);
    }
}

