/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge.slcan;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.canbridge.slcan.SLCanParser;
import com.revrobotics.canbridge.trace.CanTracer;
import com.revrobotics.canbridge.trace.PCANTracer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class SLCanContext {
    private static boolean tracingEnabled = false;
    private final SerialPort port;
    private final CanBus bus;
    private ScheduledExecutorService sendExecutor;
    static List<Consumer<CanMessage>> onMessageReceivedCallbacks = new ArrayList<Consumer<CanMessage>>();
    private final ConcurrentHashMap<Integer, RepeatableCanMessage> messagesToSend = new ConcurrentHashMap();
    private final HashMap<Integer, Long> lastSendTimes = new HashMap();
    private final ConcurrentHashMap<Integer, CanMessage> receivedMessages = new ConcurrentHashMap();
    private CanMessage lastMessage;
    private CanTracer tracer;

    public static void onMessageReceived(Consumer<CanMessage> callback) {
        onMessageReceivedCallbacks.add(callback);
    }

    SLCanContext(SerialPort port, CanBus bus, Path tracingDirectory) {
        this.port = port;
        this.bus = bus;
        if (tracingEnabled) {
            String filename = port.getSystemPortName() + "_" + System.currentTimeMillis() + "_trace.trc";
            this.tracer = new PCANTracer(tracingDirectory.resolve(filename).toAbsolutePath().toString());
        }
    }

    public static void setTracingEnabled(boolean enabled) {
        tracingEnabled = enabled;
    }

    boolean start() {
        this.port.addDataListener((SerialPortDataListener)new SerialPortMessageListener(){

            public byte[] getMessageDelimiter() {
                return "\r".getBytes(StandardCharsets.UTF_8);
            }

            public boolean delimiterIndicatesEndOfMessage() {
                return true;
            }

            public int getListeningEvents() {
                return 0x10000011;
            }

            public void serialEvent(SerialPortEvent event) {
                if (event.getEventType() == 0x10000000) {
                    SLCanContext.this.stop();
                    SLCanContext.this.port.closePort();
                    System.out.println("Closed port " + SLCanContext.this.port.getSystemPortPath());
                } else {
                    String text = new String(event.getReceivedData());
                    CanMessage message = SLCanParser.parseSLCanMessageOrNull(text);
                    if (message != null) {
                        SLCanContext.this.lastMessage = message;
                        SLCanContext.this.receivedMessages.put(message.messageId(), message);
                        if (SLCanContext.this.tracer != null) {
                            SLCanContext.this.tracer.onCanMessageReceivedByDesktop(message);
                        }
                    }
                }
            }
        });
        boolean success = this.tryOpenPort(3);
        if (!success) {
            System.out.println("Error opening port: " + this.port.getLastErrorCode() + " at line: " + this.port.getLastErrorLocation());
            return false;
        }
        this.sendOpenCommand();
        this.startSendThread();
        return true;
    }

    private boolean tryOpenPort(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            if (!this.port.openPort()) continue;
            System.out.println("Opened port " + this.port.getSystemPortPath());
            return true;
        }
        return false;
    }

    void stop() {
        this.sendExecutor.close();
    }

    void sendMessage(CanMessage message, int periodMs) {
        if (periodMs == -1) {
            this.messagesToSend.remove(message.messageId());
            this.lastSendTimes.remove(message.messageId());
        } else if (periodMs == 0) {
            this.messagesToSend.remove(message.messageId());
            this.lastSendTimes.remove(message.messageId());
            this.sendMessage(message);
        } else {
            this.messagesToSend.put(message.messageId(), new RepeatableCanMessage(periodMs, message));
        }
    }

    void sendMessage(CanMessage message) {
        String text = SLCanParser.encodeCanMessage(message);
        this.sendString(text);
        if (this.tracer != null) {
            this.tracer.onCanMessageSentByDesktop(message);
        }
    }

    private void sendString(String text) {
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        this.port.writeBytes(bytes, bytes.length);
    }

    CanBus getBus() {
        return this.bus;
    }

    String getDescriptor() {
        return this.bus.descriptor();
    }

    public boolean isOpen() {
        return this.port.isOpen();
    }

    void sendOpenCommand() {
        byte[] bytes = "S8\r".getBytes(StandardCharsets.UTF_8);
        this.port.writeBytes(bytes, bytes.length);
        bytes = "O\r".getBytes(StandardCharsets.UTF_8);
        this.port.writeBytes(bytes, bytes.length);
    }

    public int getNumBytesBackedUp() {
        return this.port.bytesAwaitingWrite();
    }

    CanMessage getLastMessage() {
        return this.lastMessage;
    }

    CanMessage getLastMessage(int messageId, int mask) {
        for (CanMessage message : this.receivedMessages.values()) {
            if ((message.messageId() & mask) != (messageId & mask)) continue;
            return message;
        }
        return null;
    }

    CanMessage getMessage(int messageId) {
        return this.receivedMessages.get(messageId);
    }

    CanMessage[] getLatestMessages(int maxAge) {
        long now = System.currentTimeMillis();
        return (CanMessage[])this.receivedMessages.values().stream().filter(message -> now - message.timestamp() <= (long)maxAge).toArray(CanMessage[]::new);
    }

    private void startSendThread() {
        this.sendExecutor = Executors.newSingleThreadScheduledExecutor(this::createSendThread);
        this.sendExecutor.scheduleAtFixedRate(this::sendThreadIterate, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    private void sendThreadIterate() {
        long now = System.currentTimeMillis();
        for (RepeatableCanMessage repeatableMessage : this.messagesToSend.values()) {
            int messageId = repeatableMessage.message.messageId();
            long lastTimeSent = 0L;
            if (this.lastSendTimes.containsKey(messageId)) {
                lastTimeSent = this.lastSendTimes.get(messageId);
            }
            if (now - lastTimeSent < (long)repeatableMessage.periodMs) continue;
            this.lastSendTimes.put(messageId, now);
            this.sendMessage(repeatableMessage.message);
        }
    }

    private Thread createSendThread(Runnable runnable) {
        Thread sendThread = new Thread(runnable);
        sendThread.setName(this.port.getSystemPortName() + " Send Thread");
        sendThread.setDaemon(true);
        return sendThread;
    }

    private record RepeatableCanMessage(int periodMs, CanMessage message) {
    }
}

