# REV Hardware Client 2 Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.0.7]

- Adds support for configuring new MAXSpline Encoder parameters
- Fixes start/stop button moving when running a SPARK

## [1.0.6]

- Fixes motors not stopping immediately when running multiple motors simultaneously
- Fixes a bug causing devices to appear as remaining in bootloader mode after updating

## [1.0.5]

- Adds button to install DFU drivers on Windows
- Adds warning when trying to run a motor without 12V
- Adds ability to reset SPARK slider to zero by double-clicking on slider handle
- Fixes splash screen not appearing in the foreground
- Fixes taskbar icon not appearing immediately on Windows
- Fixes SPARK slider setpoint resetting to zero after interacting with the minimum and maximum setpoint input boxes
- Fixes detecting MAXSpline Encoders in bootloader mode
- Fixes device drawer not defaulting to update page for devices in bootloader mode
- Fixes firmware version select taking a long time to load for devices in bootloader mode

## [1.0.4]

- Adds warning about SPARK devices with an unconfigured CAN ID
- Adds button to clear telemetry signals
- Adds dialog to move the application into the Applications folder on macOS for improved experience:
  - Fixes devices in recovery mode not appearing on macOS
  - Fixes application not updating after clicking the Update button on macOS
- Adds AdvantageScope logo
- Fixes AdvantageScope sometimes not loading layout correctly on startup or when loaded from a file
- Fixes AdvantageScope not resuming when computer wakes from sleep
- Fixes regression preventing telemetry to resume when reconnecting a device

## [1.0.3]

- Adds warning when trying to run a motor with the roboRIO present on the bus
- Adds error toast for when a SPARK parameter value is rejected
- Adds help dialog when loading devices takes a long time, especially for brand new SPARK MAXes on unsupported factory firmware
- Adds privacy policy
- Improves CAN utilization when running multiple devices on telemetry page
- Prevents multiple instances of the app from running at once
- Fixes bug causing SPARKs in brushed mode to get set to brushless upon connection
- Fixes issue with parameters not refreshing when switching devices on telemetry run tab
- Fixes spike in CAN utilization when opening a SPARK device by switching to lazy loading parameters
- Fixes issue with SPARK run slider sometimes continuing to drag with mouse after releasing
- Fixes device list sometimes not updating when unplugging USB
- Disables highlighting across general areas of the application
- Updates troubleshooting steps on about page

## [1.0.2]

- Adds ability to start and stop multiple selected motors simultaneously
- Fixes high CAN utilization when switching between many SPARK device tabs
- Fixes an issue causing some SPARKs to continue spinning when disabling multiple at once
- Fixes an issue causing SPARK devices to resume spinning after leaving the bus and returning

## [1.0.1]

- Fixes crash when opening on macOS
- Fixes detection of devices on Linux
- Fixes app icon

## [1.0.0]

Initial stable release of REV Hardware Client 2
